//AIM:Design of IIR filter.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//We will design a second order bandpass digital Butterworth filter with
// passband of 300Hz to 500Hz and sampling frequency of 1500Hz using 
//bilinear transformation method;considering prototype LPF
//with transfer functionH(s)=Ωc/s+Ωc.
//Part A:Calculation of specifications for digital filter
//First we will calculate thr required specification of the digital filter
// That means specification in terms of w
Fu=500;//Fu is the higher cut-off frequency 
Fl=300;//Fl is the lower cut-off frequency
//We want the specification in terms of wu and wl.For that,first we will calculate
//values of fu and fl by using frequency Fs=1500Hz
Fs=1500;
fu=Fu/Fs;
disp(fu,'fu=')
wu=2*%pi*fu;//It is in the units of radians/sample
disp(wu,'wu=')
fl=Fl/Fs;
disp(fl,'fl=')
wl=2*%pi*fl;//It is in the units of radians/sample
disp(wl,'wl=')
// As second order bandpass filter is considered,
//so the order of the filter is N=2
N=2;
//Part B: Calculation of specification for analog filter
Ts=1/Fs;
disp(Ts,'Ts=')
ohmu=(2/Ts)*(tan(wu/2));
ohml=(2/Ts)*(tan(wl/2));
disp(ohmu,'ohmu=')
disp(ohml,'ohml=')
//Part C:Calculation of system transfer fuction for analog BPF
s=poly(0,"s")
ohmc=1
Hs=ohmc/(s+ohmc);//H(s) is the transfer function of LPF
disp(Hs,'Hs=')
S=poly(0,"S")
s=(ohmc)*(((S^2)+(ohml*ohmu))/(S*(ohmu-ohml)))
disp(s,'s=')
Hs1=ohmc/(s+ohmc);
disp(Hs1,'Transfer function of the analog filter i.e. H(s)=')
//Part D: Calculation H(z) for digital filter
Z=poly(0,"Z")
S=(2/Ts)*((Z-1)/(Z+1));
Hz=(3016.5248*S)/(S^2+3016.5248*S+11325677)    
disp(Hz,'Transfer function of the digital filter i.e. H(z)=') 
//Plz note that manually solved answers may be a bit different due to 
//roundoff being taken,while Scilab Console will display extreme precise 
//values.
//Let us also calculate the gain
a=trfmod(Hz)
b=disp(a,'Transfer function of the digital filter(after roundoff) i.e. H(z)=')

//Expected output:
//Transfer function of the digital filter(after roundoff)                                
//         (-0.3080680+0.3080680Z^2)     
//  H(z)=  -------------------------- 
//         (0.3838640+0.1583426Z+Z^2)  

